% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_splines_data}
\alias{plot_splines_data}
\alias{plot_splines_data,Moanin,matrix-method}
\alias{plot_splines_data,Moanin,numeric-method}
\alias{plot_splines_data,Moanin,data.frame-method}
\alias{plot_splines_data,Moanin,DataFrame-method}
\alias{plot_splines_data,Moanin,missing-method}
\title{Plotting splines}
\usage{
\S4method{plot_splines_data}{Moanin,matrix}(
  object,
  data,
  colors = NULL,
  smooth = FALSE,
  legend = TRUE,
  legendArgs = NULL,
  subset_conditions = NULL,
  subset_data = NULL,
  simpleY = TRUE,
  centroid = NULL,
  scale_centroid = c("toData", "toCentroid", "none"),
  mar = c(2.5, 2.5, 3, 1),
  mfrow = NULL,
  addToPlot = NULL,
  ylab = "",
  xaxis = TRUE,
  yaxis = TRUE,
  xlab = "Time",
  ...
)

\S4method{plot_splines_data}{Moanin,numeric}(object, data, ...)

\S4method{plot_splines_data}{Moanin,data.frame}(object, data, ...)

\S4method{plot_splines_data}{Moanin,DataFrame}(object, data, ...)

\S4method{plot_splines_data}{Moanin,missing}(object, data, ...)
}
\arguments{
\item{object}{An object of class \code{\link{Moanin}}, an object containing
all related information for time course data and the splines model that
will be used (if applicable). See \code{\link{create_moanin_model}} for
more details.}

\item{data}{matrix containing the data to be plotted, where each row of the
data provided will be plotted as a separate plot. If missing, will rely on
data in \code{assay(object)}}

\item{colors}{vector, optional, default NULL. Vector of colors}

\item{smooth}{boolean, optional, default: FALSE. Whether to smooth the
centroids or not.}

\item{legend}{boolean whether to include a legend (default:TRUE)}

\item{legendArgs}{list of arguments to be passed to legend command (if
\code{legend=TRUE})}

\item{subset_conditions}{list if provided, only plots the subset of conditions
provided. Else, plots all conditions}

\item{subset_data}{list if provided, only plots the subset of data (ie, the
rows) provided. Can be any valid vector for subsetting a matrix. See
details.}

\item{simpleY}{boolean, if true, will plot all genes on same y-axis and
minimize the annotation of the y axis to only label the axis in the exterior
plots (the x-axis is always assumed to be the same across all plots and will
always be simplified)}

\item{centroid}{numeric vector (or matrix of 1 row) with data to use to fit
the splines. If \code{NULL}, the splines plotted will be from the data.}

\item{scale_centroid}{determines whether the centroid data given in
\code{centroid} should be rescaled to match that of the data
(\code{"toData"}), or the data scaled to match that of centroid
(\code{"toCentroid"}), or simply plotted as is (\code{"none"}).}

\item{mar}{vector of margins to set the space around each plot (see
\code{\link{par}})}

\item{mfrow}{a vector of integers of length 2 defining the grid of plots to be
created (see \code{\link{par}}). If missing, the function will set a value.}

\item{addToPlot}{A function that will be called after the plotting, allowing
the user to add more to the plot.}

\item{ylab}{label for the y-axis}

\item{xaxis}{Logical, whether to add x-axis labels to plot (if FALSE can be manually created by user with call to addToPlot)}

\item{yaxis}{Logical, whether to add y-axis labels to plot (if FALSE can be manually created by user with call to addToPlot)}

\item{xlab}{label for the x-axis}

\item{...}{arguments to be passed to the individual plot commands (Will be
sent to all plot commands)}
}
\value{
This function creates a plot and does not return anything to the user.
}
\description{
Plotting splines
}
\details{
If \code{data} is NULL, the data plotted will be from
  \code{assay(object)}, after log-transformation if
  \code{log_transform(object)=TRUE}.

If \code{centroid} is missing, then splines will be estimated (per
  group) for the the data in \code{data} -- separately for each row of
  \code{data}. If \code{centroid} is provided, this data will be used to plot
  a spline function, and this same spline will be plotted for each row of
  \code{data}. This is useful, for example, in plotting cluster centroids
  over a series of genes.

If the user set \code{log_transform=TRUE} in the creation of the
  \code{Moanin} object, the data will be log transformed before plotting and
  calculating the spline fits.
}
\examples{
# First, load some data and create a moanin model
data(exampleData)
moanin <- create_moanin_model(data=testData,meta=testMeta, 
   degrees_of_freedom=6)

# The moanin model contains all the information for plotting purposes. The
# plot_splines_data will automatically fit the splines from the
# information contained in the moanin model
genes <- c("NM_001042489", "NM_008725")
plot_splines_data(moanin, subset_data=genes,
mfrow=c(2, 2))
# By default, same axis for all genes. Can change with 'simpleY=FALSE'
plot_splines_data(moanin, subset_data=genes,
   smooth=TRUE, mfrow=c(2,2), simpleY=FALSE)   

# The splines can also be smoothed
plot_splines_data(moanin, subset_data=genes,
   smooth=TRUE, mfrow=c(2, 2))
# You can provide different data (on same subjects),
# instead of data in moanin object
# (in which case moanin just provides grouping information)
plot_splines_data(moanin, data=1/assay(moanin), subset_data=genes,
   smooth=TRUE, mfrow=c(2, 2))
   
# You can also provide data to use for fitting splines to argument  
# "centroid". This is helpful for overlaying centroids or predicted data
# Here we do a silly example, just to demonstrate syntax, 
# where we use the data from the first gene as our centroid to fit a
# spline estimate, but plot data from genes 3-4
plot_splines_data(moanin, centroid=assay(moanin[1,]), subset_data=3:4,
   smooth=TRUE, mfrow=c(2,2))
}
