% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiablo.R
\name{plotDiablo}
\alias{plotDiablo}
\alias{plot.sgccda}
\title{Graphical output for the DIABLO framework}
\usage{
plotDiablo(
  object,
  ncomp = 1,
  legend = TRUE,
  legend.ncol,
  col.per.group = NULL,
  ...
)

\method{plot}{sgccda}(x, ...)
}
\arguments{
\item{object, x}{object of class inheriting from \code{"block.splsda"}.}

\item{ncomp}{Which component to plot calculated from each data set. Has to
be lower than the minimum of \code{object$ncomp}.}

\item{legend}{Logical. Whether the legend should be added. Default is TRUE.}

\item{legend.ncol}{Number of columns for the legend. Default to
\code{min(5,nlevels(x$Y))}.}

\item{col.per.group}{A named character of colours for each group class
representation. Its names must match the levels of object$Y.}

\item{\dots}{not used}
}
\value{
none
}
\description{
Function to visualise correlation between components from different data
sets
}
\details{
The function uses a plot.data.frame to plot the component \code{ncomp}
calculated from each data set to visualise whether DIABLO (block.splsda) is
successful at maximising the correlation between each data sets' component.
The lower triangular panel indicated the Pearson's correlation coefficient,
the upper triangular panel the scatter plot.
}
\examples{
data('breast.TCGA')
Y = breast.TCGA$data.train$subtype

data = list(mrna =  breast.TCGA$data.train$mrna,
mirna =  breast.TCGA$data.train$mirna, prot =  breast.TCGA$data.train$protein)

# set number of component per data set
ncomp = 3
# set number of variables to select, per component and per data set (arbitrarily set)
list.keepX = list(mrna = rep(20, 3), mirna = rep(10,3), prot = rep(10,3))

# DIABLO using a full design where every block is connected
BC.diablo = block.splsda(X = data, Y = Y, ncomp = ncomp, keepX = list.keepX, design = 'full')
## default col.per.group
plotDiablo(BC.diablo, ncomp = 1, legend = TRUE, col.per.group = NULL)
## custom col.per.group
col.per.group <- color.mixo(1:3)
names(col.per.group) <- levels(Y)
plotDiablo(BC.diablo, ncomp = 1, legend = TRUE, col.per.group = col.per.group)
}
\references{
Singh A., Shannon C., Gautier B., Rohart F., Vacher M., Tebbutt S.
and Lê Cao K.A. (2019), DIABLO: an integrative approach for identifying key 
molecular drivers from multi-omics assays, Bioinformatics, 
Volume 35, Issue 17, 1 September 2019, Pages 3055–3062.
}
\seealso{
\code{\link{block.splsda}} and http://www.mixOmics.org/mixDIABLO
for more details.
}
\author{
Amrit Singh, Florian Rohart, Kim-Anh Lê Cao, Al J Abadi
}
\keyword{multivariate}
\keyword{regression}
