% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods-plot.perf.pls.R
\name{plot.perf.pls}
\alias{plot.perf.pls}
\alias{plot.perf.pls.mthd}
\alias{plot.perf.spls.mthd}
\title{Plot for model performance for PLS analyses}
\usage{
\method{plot}{perf.pls.mthd}(
  x,
  criterion = "MSEP",
  xlab = "Number of components",
  ylab = NULL,
  LimQ2 = 0.0975,
  LimQ2.col = "grey30",
  sd = NULL,
  pch = 1,
  pch.size = 3,
  cex = 1.2,
  col = color.mixo(1),
  title = NULL,
  ...
)

\method{plot}{perf.spls.mthd}(
  x,
  criterion = "MSEP",
  xlab = "Number of components",
  ylab = NULL,
  LimQ2 = 0.0975,
  LimQ2.col = "grey30",
  sd = NULL,
  pch = 1,
  pch.size = 3,
  cex = 1.2,
  col = color.mixo(1),
  title = NULL,
  ...
)
}
\arguments{
\item{x}{an \code{perf.pls} object.}

\item{criterion}{character string. What type of validation criterion to plot
for \code{pls} or \code{spls}. One of \code{"MSEP"}, \code{"RMSEP"},
\code{"R2"} or \code{"Q2"}. More measures available for pls2 methods. See
\code{\link{perf}}.}

\item{xlab, ylab}{titles for \eqn{x} and \eqn{y} axes.  Typically character
strings, but can be expressions (e.g., \code{expression(R^2)}).}

\item{LimQ2}{numeric value. Signification limit for the components in the
model. Default is \code{LimQ2 = 0.0975}.}

\item{LimQ2.col}{character string specifying the color for the \code{LimQ2}
line to be plotted. If \code{"none"} the line will not be plotted.}

\item{sd}{If 'nrepeat' was used in the call to 'perf', error bar shows the
standard deviation if sd=TRUE. For mint objects sd is set to FALSE as the
number of repeats is 1.}

\item{pch}{Plot character to use.}

\item{pch.size}{Plot character size to use.}

\item{cex}{A numeric which adjusts the font size in the plot.}

\item{col}{Character. Colour to be used for data points.}

\item{title}{Character, Plot title. Not used by PLS2 feature-wise measure
plots.}

\item{...}{Not used.}
}
\value{
none
}
\description{
Function to plot performance criteria, such as MSEP, RMSEP, \eqn{R^2},
\eqn{Q^2} for s/PLS methods as a function of the number of components.
}
\details{
\code{plot.perf} creates one plot for each response variable in the model,
laid out in a multi-panel display. See ?perf for examples.
}
\references{
Rohart F, Gautier B, Singh A, Lê Cao K-A. mixOmics: an R package for 'omics
feature selection and multiple data integration. PLoS Comput Biol 13(11):
e1005752
}
\seealso{
\code{\link{pls}}, \code{\link{spls}}, \code{\link{plsda}},
\code{\link{splsda}}, \code{\link{perf}}.
}
\author{
Al J Abadi
}
\keyword{hplot}
\keyword{multivariate}
\keyword{regression}
