% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods-print.R
\name{print}
\alias{print}
\alias{print.mixo_pls}
\alias{print.rcc}
\alias{print.mixo_spls}
\alias{print.summary}
\alias{print.pca}
\alias{print.spca}
\alias{print.rgcca}
\alias{print.sgcca}
\alias{print.mint.pls}
\alias{print.mixo_plsda}
\alias{print.mint.plsda}
\alias{print.mint.spls}
\alias{print.mixo_splsda}
\alias{print.mint.splsda}
\alias{print.ipca}
\alias{print.sipca}
\alias{print.sgccda}
\alias{print.perf.pls.mthd}
\alias{print.perf.plsda.mthd}
\alias{print.perf.splsda.mthd}
\alias{print.perf.mint.splsda.mthd}
\alias{print.perf.sgccda.mthd}
\alias{print.tune.pca}
\alias{print.tune.spca}
\alias{print.tune.rcc}
\alias{print.tune.splsda}
\alias{print.tune.pls}
\alias{print.tune.spls1}
\alias{print.tune.mint.splsda}
\alias{print.tune.block.splsda}
\alias{print.predict}
\title{Print Methods for CCA, (s)PLS, PCA and Summary objects}
\usage{
\method{print}{mixo_pls}(x, ...)

\method{print}{mint.pls}(x, ...)

\method{print}{mixo_plsda}(x, ...)

\method{print}{mint.plsda}(x, ...)

\method{print}{mixo_spls}(x, ...)

\method{print}{mint.spls}(x, ...)

\method{print}{mixo_splsda}(x, ...)

\method{print}{mint.splsda}(x, ...)

\method{print}{rcc}(x, ...)

\method{print}{pca}(x, ...)

\method{print}{ipca}(x, ...)

\method{print}{sipca}(x, ...)

\method{print}{rgcca}(x, ...)

\method{print}{sgcca}(x, ...)

\method{print}{sgccda}(x, ...)

\method{print}{summary}(x, ...)

\method{print}{perf.pls.mthd}(x, ...)

\method{print}{perf.plsda.mthd}(x, ...)

\method{print}{perf.splsda.mthd}(x, ...)

\method{print}{perf.mint.splsda.mthd}(x, ...)

\method{print}{perf.sgccda.mthd}(x, ...)

\method{print}{tune.pca}(x, ...)

\method{print}{tune.spca}(x, ...)

\method{print}{tune.rcc}(x, ...)

\method{print}{tune.splsda}(x, ...)

\method{print}{tune.pls}(x, ...)

\method{print}{tune.spls1}(x, ...)

\method{print}{tune.mint.splsda}(x, ...)

\method{print}{tune.block.splsda}(x, ...)

\method{print}{predict}(x, ...)
}
\arguments{
\item{x}{object of class inherited from \code{"rcc"}, \code{"pls"},
\code{"spls"}, \code{"pca"}, \code{"spca"}, \code{"rgcca"}, \code{"sgcca"} or
\code{"summary"}.}

\item{...}{not used currently.}
}
\value{
none
}
\description{
Produce \code{print} methods for class \code{"rcc"}, \code{"pls"},
\code{"spls"}, \code{"pca"}, \code{"rgcca"}, \code{"sgcca"} and
\code{"summary"}.
}
\details{
\code{print} method for \code{"rcc"}, \code{"pls"}, \code{"spls"}
\code{"pca"}, \code{"rgcca"}, \code{"sgcca"} class, returns a description of
the \code{x} object including: the function used, the regularization
parameters (if \code{x} of class \code{"rcc"}), the (s)PLS algorithm used
(if \code{x} of class \code{"pls"} or \code{"spls"}), the samples size, the
number of variables selected on each of the sPLS components (if \code{x} of
class \code{"spls"}) and the available components of the object.

\code{print} method for \code{"summary"} class, gives the (s)PLS algorithm
used (if \code{x} of class \code{"pls"} or \code{"spls"}), the number of
variates considered, the canonical correlations (if \code{x} of class
\code{"rcc"}), the number of variables selected on each of the sPLS
components (if \code{x} of class \code{"spls"}) and the available components
for Communalities Analysis, Redundancy Analysis and Variable Importance in
the Projection (VIP).
}
\examples{
## print for objects of class 'rcc'
data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene
nutri.res <- rcc(X, Y, ncomp = 3, lambda1 = 0.064, lambda2 = 0.008)
print(nutri.res)

\dontrun{
## print for objects of class 'summary'
more <- summary(nutri.res, cutoff = 0.65)
print(more)

## print for objects of class 'pls'
data(linnerud)
X <- linnerud$exercise
Y <- linnerud$physiological
linn.pls <- pls(X, Y)
print(linn.pls)

## print for objects of class 'spls'
data(liver.toxicity)
X <- liver.toxicity$gene
Y <- liver.toxicity$clinic
toxicity.spls <- spls(X, Y, ncomp = 3, keepX = c(50, 50, 50),
keepY = c(10, 10, 10))
print(toxicity.spls)
}
}
\seealso{
\code{\link{rcc}}, \code{\link{pls}}, \code{\link{spls}},
\code{\link{vip}}.
}
\author{
Sébastien Déjean, Ignacio González, Kim-Anh Lê Cao, Fangzhou Yao, Jeff Coquery, Al J Abadi.
}
\keyword{multivariate}
\keyword{regression}
