% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{mitoPlot}
\alias{mitoPlot}
\title{Plot clone-specific variants in circular plots}
\usage{
mitoPlot(
  variants,
  patient = NULL,
  genome = "hg38",
  customGenome = NULL,
  showLegend = TRUE,
  showLabel = TRUE
)
}
\arguments{
\item{variants}{Character vector of variants to plot in format
5643G>T or 5643 G>T.}

\item{patient}{Characet vector identifying which variant belongs to
what clone. The order should match that of the 'vars' parameter
and shoul dbe of identical length. If none is provided, the
function assumes all variants are from one single sample which
will be named "Main Clone". Default: NULL.}

\item{genome}{The mitochondrial genome of the sample being
investigated. Please note that this is the UCSC standard
chromosome sequence. Default: hg38.}

\item{customGenome}{A GRanges object containing a custom annotation.
If provided, this genome will be used instead of the predefined options
specified by the `genome` parameter. Default is NULL.}

\item{showLegend}{Boolean for whether or not the gene legend should
be present in the final output plot. Default: TRUE.}

\item{showLabel}{Boolean for whether or not the name of the variant
should be shown as a label in the final output plot. Default:
TRUE.}
}
\value{
A ggplot object illustrating the clone specific mutations.
}
\description{
Plot clone-specific variants in circular plots
}
\examples{
known.variants <- c("9001 T>C","12345 G>A","1337 G>A")
mitoPlot(known.variants)
}
