% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_view_contributions}
\alias{plot_view_contributions}
\title{Plot view contributions per target}
\usage{
plot_view_contributions(
  misty.results,
  trim = -Inf,
  trim.measure = c("gain.R2", "multi.R2", "intra.R2", "gain.RMSE", "multi.RMSE",
    "intra.RMSE")
)
}
\arguments{
\item{misty.results}{a results list generated by
\code{\link{collect_results}()}.}

\item{trim}{display targets with performance value above (if R2 or gain) or
below (otherwise) this value only.}

\item{trim.measure}{the measure used for trimming.}
}
\value{
The \code{misty.results} list (invisibly).
}
\description{
Generate a stacked barplot of the average view contribution fraction per target
across all samples from the results.
}
\examples{
all.samples <- list.dirs("results", recursive = FALSE)

collect_results(all.samples) \%>\% plot_view_contributions()
}
\seealso{
\code{\link{collect_results}()} to generate a
    results list from raw results.

Other plotting functions: 
\code{\link{plot_contrast_heatmap}()},
\code{\link{plot_contrast_results}()},
\code{\link{plot_improvement_stats}()},
\code{\link{plot_interaction_communities}()},
\code{\link{plot_interaction_heatmap}()}
}
\concept{plotting functions}
