% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_interaction_heatmap}
\alias{plot_interaction_heatmap}
\title{Plot importance heatmap for a view}
\usage{
plot_interaction_heatmap(
  misty.results,
  view,
  cutoff = 1,
  trim = -Inf,
  trim.measure = c("gain.R2", "multi.R2", "intra.R2", "gain.RMSE", "multi.RMSE",
    "intra.RMSE"),
  clean = FALSE
)
}
\arguments{
\item{misty.results}{a results list generated by
\code{\link{collect_results}()}.}

\item{view}{abbreviated name of the view.}

\item{cutoff}{importance threshold. Importances below this value will
be colored white in the heatmap and considered as not relevant.}

\item{trim}{display targets with performance value above (if R2 or gain) or
below (otherwise) this value only.}

\item{trim.measure}{the measure used for trimming.}

\item{clean}{a \code{logical} indicating whether to remove rows and columns
with all importances are below \code{cutoff} from the heatmap.}
}
\value{
The \code{misty.results} list (invisibly).
}
\description{
Generate a heatmap with importances of predictor-target interaction.
}
\examples{
all.samples <- list.dirs("results", recursive = FALSE)

collect_results(all.samples) \%>\%
  plot_interaction_heatmap("intra") \%>\%
  plot_interaction_heatmap("para.10", cutoff = 0.5)
}
\seealso{
\code{\link{collect_results}()} to generate
    a results list from raw results.

Other plotting functions: 
\code{\link{plot_contrast_heatmap}()},
\code{\link{plot_contrast_results}()},
\code{\link{plot_improvement_stats}()},
\code{\link{plot_interaction_communities}()},
\code{\link{plot_view_contributions}()}
}
\concept{plotting functions}
