% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_contrast_results}
\alias{plot_contrast_results}
\title{Plot heatmap of contrast between two result lists}
\usage{
plot_contrast_results(
  misty.results.from,
  misty.results.to,
  views = NULL,
  cutoff.from = 1,
  cutoff.to = 1,
  trim = -Inf,
  trim.measure = c("gain.R2", "multi.R2", "intra.R2", "gain.RMSE", "multi.RMSE",
    "intra.RMSE")
)
}
\arguments{
\item{misty.results.from, misty.results.to}{a results list generated by
\code{\link{collect_results}()}.}

\item{views}{one or more abbreviated names of views.}

\item{cutoff.from, cutoff.to}{importance thresholds respective to the result
lists.}

\item{trim}{display targets with performance value above (if R2 or gain) or
below (otherwise) this value only.}

\item{trim.measure}{the measure used for trimming.}
}
\value{
The \code{misty.results.from} list (invisibly).
}
\description{
Plot interexperiment contrast of views.
}
\details{
The heatmaps show the interactions that are present and have importance above
a \code{cutoff.to} value in the \code{views} of \code{misty.results.to} but
not present or have importance below \code{cutoff.from} in the \code{views}
of \code{misty.results.from}.
}
\examples{
# if for example the available samples come from different grades of tumors

grade1.results <- collect_results(c("results/synthetic1", "results/synthetic2"))
grade3.results <- collect_results("results/synthetic10")

# highlight interactions present in grade 1 tumors but not in grade 3 tumors
# in the paraview

grade3.results \%>\% plot_contrast_results(grade1.results, views = "para.10")

# see the loss of interactions in all views with lower sensitivity

plot_contrast_results(grade3.results, grade1.results, cutoff.from = 0.75, cutoff.to = 0.5)
}
\seealso{
\code{\link{collect_results}()} to generate a
    results list from raw results.

Other plotting functions: 
\code{\link{plot_contrast_heatmap}()},
\code{\link{plot_improvement_stats}()},
\code{\link{plot_interaction_communities}()},
\code{\link{plot_interaction_heatmap}()},
\code{\link{plot_view_contributions}()}
}
\concept{plotting functions}
