% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estiParam.R
\name{estiParam}
\alias{estiParam}
\title{Parameter Estimation With mist}
\usage{
estiParam(
  Dat_sce,
  Dat_name,
  ptime_name,
  BPPARAM = MulticoreParam(),
  verbose = TRUE
)
}
\arguments{
\item{Dat_sce}{A \code{SingleCellExperiment} object containing the single-cell DNA methylation level.
Methylation levels should be stored as an assay, with genomic feature (gene) names in rownames
and cells in colnames.}

\item{Dat_name}{A character string specifying the name of the assay to extract the methylation level data.}

\item{ptime_name}{A character string specifying the name of the column in \code{colData} containing the pseudotime vector.}

\item{BPPARAM}{A \code{BiocParallelParam} object specifying the parallel backend for computations, as used in \code{bplapply()}. Defaults to \code{MulticoreParam()} for parallel processing.}

\item{verbose}{A logical value indicating whether to print progress messages to the console.
Defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages.}
}
\value{
The updated sce object with A numeric matrix of estimated parameters for all genomic features in the rowData, including:
\itemize{
\item \eqn{\beta_0} to \eqn{\beta_4}: Estimated coefficients for the polynomial of degree 4.
\item \eqn{\sigma^2_1} to \eqn{\sigma^2_4}: Estimated variances for each stage along the pseudotime.
}
}
\description{
This function performs the Gibbs sampling procedure based on hierarchical Bayesian modeling
to produce the parameters required for differential methylation analysis.
}
\examples{
library(SingleCellExperiment)
data <- readRDS(system.file("extdata", "group1_sampleData_sce.rds", package = "mist"))
Dat_sce_new <- estiParam(
    Dat_sce = data,
    Dat_name = "Methy_level_group1",
    ptime_name = "pseudotime"
)
}
