\name{NCI60}

\alias{NCI60}

\docType{data}

\title{Data of the NCI-60 Cell Lines with Missing Individuals}

\description{
The \code{NCI60} data contain both transcriptomic and proteomic
expression for a collection of 60 cell lines from the National
Cancer Institute (NCI-60). Data tables with missing individuals 
have been generated for illustration purposes.
}

\usage{data(NCI60)}

\format{
A list with two components, \code{dataTables} and \code{mae}:

\code{dataTables} contain a list with the following components:

\describe{
    \item{\code{trans}}{a matrix containing 300 rows and 48 columns.
        The mRNA transcription levels of the NCI60 cell lines. There
        are 12 missing individuals.}

    \item{\code{prote}}{a matrix containing 162 rows and 52 columns.
        The protein abundance levels of the NCI60 cell lines. There
        are 8 missing individuals.}
        
    \item{\code{cell.line}}{a \code{DataFrame} of cancer types:
        colon (CO), renal (RE), ovarian (OV), breast (BR),
        prostate (PR), lung (LC), central nervous system (CNS),
        leukemia (LE) and melanoma (ME).}
}

\code{mae} contain a 'MultiAssayExperiment' instance from NCI60 data with
transcriptome and proteomic experiments as described in \code{dataTables}.
}

\details{
The transcriptome data was retrieved directly from the
\code{NCI60_4arrays} package. This data table contains gene
expression profiles generated by the Agilent platform with only
few hundreds of genes randomly selected to keep the size of the
Bioconductor package small. However, the full dataset is available
in Reinhold \emph{et al.} (2012).

The proteomic data was retrieved directly from the
\code{rcellminerData} package. Protein abundance levels were
available for 162 proteins.

The scripts used to generate this data are contained within
the inst/extdata folder of the \code{missRows} package.
}

\source{
\code{NCI60_4arrays} package.

\code{rcellminerData} package.
}

\references{
Reinhold W.C., Sunshine M., Liu H., Varma S., Kohn K.W., Morris J.,
Doroshow J., Pommier Y. (2012).
Cellminer: A web-based suite of genomic and pharmacologic tools to
explore transcript and drug patterns in the NCI-60 cell line set.
\emph{Cancer Research}, 72(14):3499-511.

The CellMiner project website: http://discover.nci.nih.gov/cellminer
}

\keyword{datasets}
