% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runModels.R
\name{runModels}
\alias{runModels}
\title{runModels runs miRNA mrna model model for various miRNA-mRNA data distributions}
\usage{
runModels(
  combination,
  select_mRNA,
  select_miRNA,
  mode = NULL,
  family = glm_poisson(),
  scale = 1,
  cutoff = 0.05,
  all_coeff = NULL
)
}
\arguments{
\item{combination}{the combined file for mRNA and selected miRNAs output of combiner function}

\item{select_mRNA}{the output of gene_variant function.}

\item{select_miRNA}{The vector of miRNA/s to be investigated.}

\item{mode}{the mode of analysis if more than one miRNA is being investigated multivariate "multi"
or co-variate/interaction analysis "inter" is being used}

\item{family}{gaussian or poisson}

\item{scale}{factor to scale input data (for genes) by, prior to rounding and model
fitting. (\code{scale} must be greater than zero).}

\item{cutoff}{p-value cut off to call significance}

\item{all_coeff}{if true only models with all negative coefficients will be selected if false at least one}
}
\value{
A list of p-vlaues, annova, and significance for each gene and the miRNA/s of interest
}
\description{
This function defines the boundaries of mRNA vs miRNAs of interest to be analysed by the runModels function
}
\examples{
x <- runModels(Combine, geneVariant, "ebv-mir-bart9-5p")
}
\keyword{glm}
\keyword{interaction}
\keyword{multivariate}
\keyword{runModels}
\keyword{univariate}
