% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsFilter.R
\name{modelsFilter}
\alias{modelsFilter}
\title{modelsFilter Filter a list of models based on logical expression}
\usage{
modelsFilter(models, expr, quiet = FALSE)
}
\arguments{
\item{models}{list of models and related elemenets, such as returned by \code{runModelsZInf()}}

\item{expr}{expresion that yields a logical vector (evaluated in the environmnet of \code{model})}

\item{quiet}{suppress warnings}
}
\value{
\code{models} but with all elements filtered by logical expression \code{expr}. Elements
        for which filter could not be applied (e.g. length mismatch between element and condition)
        are set to \code{NA}.
}
\description{
This function can be used to filter a list of models (such as returned by \code{runModelsZInf()})
based on a logical expression.
}
\examples{
\donttest{
x <- modelsFilter(models, pvalues < 0.05)
x <- modelsFilter(models, is_significant)
x <- modelsFilter(models, is_significant == FALSE)
}
}
\keyword{R}
\keyword{filter}
\keyword{models}
