% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_pathways.R
\name{plot_change}
\alias{plot_change}
\title{Plotting the change in pathways order}
\usage{
plot_change(original_pathways, augmented_pathways, pathway_names, ...)
}
\arguments{
\item{original_pathways}{A list of 
graph::graphNEL objects where each of the nodes is named with '<gene_ID>'.
Nodes of each graph::graphNEL represent the genes involved in the 
pathway and edges represent the biological interactions (activation or
repression) among those genes (activation or repression).}

\item{augmented_pathways}{A list of 
graph::graphNEL objects where each of the nodes is named with '<gene_ID>'.
Nodes of each graph::graphNEL represent genes 
and miRNAs involved in the 
pathway and edges represent the biological interactions (activation or 
repression) among them.}

\item{pathway_names}{A list of names of the pathways named by '<pathway_ID>'.}

\item{...}{Other arguments for the '<plotLines>' function.}
}
\value{
A lines plot of the comparison of pathways order.
}
\description{
Function for plotting a lines plot of the difference in pathways' order.
The resultant plot shows the comparison between the order of the original 
pathways 
and the order of the augmented pathways. It also contains a line with
the order difference (order of the augmented pathways minus 
order of the original pathways). The order of a biological pathway is 
the number of genes that are involved in it.
}
\examples{
data(augmented_pathways)
data(kegg_pathways)
data(names_pathways)
plot_change(kegg_pathways,augmented_pathways, names_pathways)

}
\author{
Diana Diaz <dmd at wayne dot edu>
}

