% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_dis.R
\name{sim_par}
\alias{sim_par}
\title{Function for community similarity calculation used by `tina`, modified from
https://github.com/defleury/Schmidt_et_al_2016_community_similarity/blob/
master/functions.community_similarity.R}
\usage{
sim_par(x, y, sim_method = "w_ja", threads = 80, nblocks = 400)
}
\arguments{
\item{x}{An quantitative matrix.}

\item{y}{The Cij matrix, which is correlation matrix of adjusted sparcc
matrix of x.}

\item{sim_method}{The method for similarity, "w_ja" and "uw_ja" are
available for weighted and unweighted Jaccard similarity respectively.}

\item{threads}{The number of threads used for parallel running, 80 by
default.}

\item{nblocks}{The number of row / column for splitted sub-matrix, 400 by
default.}
}
\value{
s The output similarity matrix.
}
\description{
Function for community similarity calculation used by `tina`, modified from
https://github.com/defleury/Schmidt_et_al_2016_community_similarity/blob/
master/functions.community_similarity.R
}
\examples{
\dontrun{
data(maize_asv)
maize_tab <- maize_asv[1 : 1000, 1 : 200]
asv <- norm_tab(maize_tab, method = "raref", depth = 100)
asv[is.na(asv)] <- 0
asv_sparcc <- sparcc(asv, threads = 8, nblocks = 40)
tmp.S <- adj(asv_sparcc, method = "spearman")
y <- 0.5 * (tmp.S + 1)
s <- sim_par(asv_sparcc, y, sim_method = "w_ja", threads = 8, nblocks = 40)
}
}
\keyword{internal}
