% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R
\name{net_dis}
\alias{net_dis}
\title{Calculate the network distance of `multi` and test the significance when
`perm` is defined.}
\usage{
net_dis(x, method, ...)
}
\arguments{
\item{x}{An object of class `mina` with `multi` (and `perm` if `sig` is TRUE)
defined.}

\item{method}{The distance to be calculated, "spectra" and "Jaccard" are
available.}

\item{...}{Additional parameters.}
}
\value{
The netowrk comparison result.
}
\description{
Calculate the network distance of `multi` and test the significance when
`perm` is defined.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- get_rep(maize, top = 5)
maize <- bs_pm(maize, group = "Compartment")
maize <- net_dis(maize, method = "spectra", evk = 30)
}
