% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_r2.R
\name{get_r2,matrix,ANY,ANY-method}
\alias{get_r2,matrix,ANY,ANY-method}
\alias{get_r2,matrix,data.frame,ANY-method}
\alias{get_r2,matrix,data.frame,character-method}
\title{Function for unexplained variance ratio calculation indicated in
Anderson, M.J. 2001. A new method for non-parametric multivariate analysis of
variance. Austral Ecology, 26: 32--46.}
\usage{
\S4method{get_r2}{matrix,ANY,ANY}(x, des, group)

\S4method{get_r2}{matrix,data.frame,ANY}(x, des, group)

\S4method{get_r2}{matrix,data.frame,character}(x, des, group = c("Host_genotype", "Compartment", "Soil", "Management"))
}
\arguments{
\item{x}{Dissimilarity / distance matrix which indicate variances.}

\item{des}{The descriptive table of samples which define the groups.}

\item{group}{The name(s) of column(s) used  as experimental setup group(s) in
descriptive file.}
}
\value{
r2 The variance ratio cannot be explained by given groups.
}
\description{
Function for unexplained variance ratio calculation indicated in
Anderson, M.J. 2001. A new method for non-parametric multivariate analysis of
variance. Austral Ecology, 26: 32--46.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
x <- dis(maize)
des <- des(maize)
get_r2(x, des, group = c("Compartment", "Soil"))
}
