% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R
\name{com_dis}
\alias{com_dis}
\title{Calculate the community dissimilarity / distance matrix.}
\usage{
com_dis(x, method = "bray", ...)
}
\arguments{
\item{x}{An object of the class mina with `norm` defined or any quantitative
matrix.}

\item{method}{The dissimilarity / distance method used, default `bray`.}

\item{...}{Additional parameters.}
}
\value{
The distance / dissimilarity matrix.
}
\description{
Calculate the community dissimilarity / distance matrix.
}
\examples{
asv_norm <- norm_tab(maize_asv2, method = "raref", depth = 1000)
asv_dis <- com_dis(asv_norm, method = "bray")
}
