% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj.R
\name{adj,matrix,ANY-method}
\alias{adj,matrix,ANY-method}
\alias{adj,matrix,character-method}
\title{Calculate the adjacency matrix of `norm` by correlation with matrix as input.}
\usage{
\S4method{adj}{matrix,ANY}(x, method, sig = FALSE, threads = 80, nblocks = 400, ...)

\S4method{adj}{matrix,character}(x, method, sig = FALSE, threads = 80, nblocks = 400, ...)
}
\arguments{
\item{x}{An object of the class mina with `norm` defined or a `norm` matrix.}

\item{method}{The correlation coeffient used for adjacacency matrix.}

\item{sig}{(optional) The asymtotic P-values, only applicable for Pearson
and Spearman methods with `mina` object as input, alwasy FALSE here.}

\item{threads}{The number of threads used for parallel running, 80 by
default.}

\item{nblocks}{The number of row/column for splitting sub-matrix, 400 by
default.}

\item{...}{Additional parameters.}
}
\value{
y The adjacency matrix.
}
\description{
Calculate the adjacency matrix of `norm` by correlation with matrix as input.
}
\examples{
asv_norm <- norm_tab(maize_asv2, method = "raref", depth = 1000)
asv_adj <- adj(asv_norm, method = "pearson")
}
