% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNhoods.R
\name{plotNhoodMA}
\alias{plotNhoodMA}
\title{Visualize DA results as an MAplot}
\usage{
plotNhoodMA(da.res, alpha = 0.05, null.mean = 0)
}
\arguments{
\item{da.res}{A data.frame of DA testing results}

\item{alpha}{A numeric scalar that represents the Spatial FDR threshold for statistical significance.}

\item{null.mean}{A numeric scalar determining the expected value of the log fold change under the null
hypothesis. \code{default=0}.}
}
\value{
a \code{ggplot} object
}
\description{
Make an MAplot to visualise the relationship between DA log fold changes and neighbourhood abundance. This
is a useful way to diagnose issues with the DA testing, such as large compositional biases and/or issues
relating to large imbalances in numbers of cells between condition labels/levels.
}
\details{
MA plots provide a useful means to evaluate the distribution of log fold changes after differential
abundance testing. In particular, they can be used to diagnose global shifts that occur in the presence of
confounding between the number of cells acquired and the experimental variable of interest. The expected null
value for the log FC distribution (grey dashed line), along with the mean observed log fold change for non-DA
neighbourhoods (purple dashed line) are plotted for reference. The deviation between these two lines can give
an indication of biases in the results, such as in the presence of a single strong region of DA leading to an
increase in false positive DA neighbourhoods in the opposite direction.
}
\examples{
NULL

}
\author{
Mike Morgan
}
