% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNhoods.R
\name{plotDAbeeswarm}
\alias{plotDAbeeswarm}
\title{Visualize DA results as a beeswarm plot}
\usage{
plotDAbeeswarm(da.res, group.by = NULL, alpha = 0.1, subset.nhoods = NULL)
}
\arguments{
\item{da.res}{a data.frame of DA testing results}

\item{group.by}{a character scalar determining which column of \code{da.res} to use for grouping.
This can be a column added to the DA testing results using the `annotateNhoods` function.
If \code{da.res[,group.by]} is a character or a numeric, the function will coerce it to a factor (see details)
(default: NULL, no grouping)}

\item{alpha}{significance level for Spatial FDR (default: 0.1)}

\item{subset.nhoods}{A logical, integer or character vector indicating a subset of nhoods to show in plot
(default: NULL, no subsetting)}
}
\value{
a \code{ggplot} object
}
\description{
This function constructs a beeswarm plot using the ggplot engine to visualise the distribution of
log fold changes across neighbourhood annotations.
}
\details{
The group.by variable will be coerced to a factor. If you want the variables in group.by to be
in a given order make sure you set the column to a factor with the levels in the right order before running the
function.
}
\examples{
NULL

}
\author{
Emma Dann
}
