% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{omnibusTest}
\alias{omnibusTest}
\title{Omnibus test}
\usage{
omnibusTest(
  object,
  omnibus_groups,
  placeholder = "term",
  correction = "bonferroni",
  n_correction = NULL
)
}
\arguments{
\item{object}{An existing fit from a model function such as lm, glm and many
others.}

\item{omnibus_groups}{List of character vectors giving sets of variables for
which omnibus test should be applied.}

\item{placeholder}{String specifying term in \code{object}'s formula which
should be substituted with variables during analysis.}

\item{correction}{String specifying multiple testing correction method. See
details for further information.}

\item{n_correction}{Integer specifying number of comparisons to consider
during multiple testing correction calculations. For Bonferroni correction
it is possible to specify a number lower than the number of comparisons
being made. This is useful in cases when knowledge about the biology or
redundance of alleles reduces the need for correction. For other methods it
must be at least equal to the number of comparisons being made; only set
this (to non-default) when you know what you are doing!}
}
\value{
Data frame with columns:
  \itemize{
    \item{"group"}{ Omnibus group name}
    \item{"term"}{ Elements of omnibus group added to base model}
    \item{"df"}{ Difference in degrees of freedom between base and extended model}
    \item{"logLik"}{ Difference in log likelihoods between base and extended model}
    \item{"statistic"}{ Chisq statistic}
    \item{"p.value"}{ P-value}
    \item{"p.adjusted"}{ Adjusted p-value}
  }
}
\description{
\code{OmnibusTest} calculates overall p-value for linear combination of
variables using likelihood ratio test.
}
\details{
Likelihood ratio test is conducted by comparing a model given in an
\code{object} with an extended model, that is created by including the effect
of variables given in \code{variables} as their linear combination.
}
\examples{
midas <- prepareMiDAS(hla_calls = MiDAS_tut_HLA,
                      colData = MiDAS_tut_pheno,
                      experiment = "hla_aa")

# define base model
object <- lm(disease ~ term, data = midas)
omnibusTest(object,
            omnibus_groups = list(
              A_29 = c("A_29_D", "A_29_A"),
              A_43 = c("A_43_Q", "A_43_R")
            ))

}
