% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{kableResults}
\alias{kableResults}
\title{Create association analysis results table in HTML or LaTeX}
\usage{
kableResults(
  results,
  colnames = NULL,
  header = "MiDAS analysis results",
  pvalue_cutoff = NULL,
  format = getOption("knitr.table.format"),
  scroll_box_height = "400px"
)
}
\arguments{
\item{results}{Tibble as returned by \code{\link{runMiDAS}}.}

\item{colnames}{Character vector of form \code{c("new_name" = "old_name")},
used to rename \code{results} colnames.}

\item{header}{String specifying results table header.}

\item{pvalue_cutoff}{Number specifying p-value cutoff for results to be
included in output. If \code{NULL} no filtering is done.}

\item{format}{String \code{"latex"} or \code{"html"}.}

\item{scroll_box_height}{A character string indicating the height of the table.}
}
\value{
Association analysis results table in HTML or LaTeX.
}
\description{
\code{kableResults} convert results table (\code{\link{runMiDAS}} output) to
HTML or LaTeX format.
}
\examples{
midas <- prepareMiDAS(hla_calls = MiDAS_tut_HLA,
                      colData = MiDAS_tut_pheno,
                      experiment = "hla_alleles")
object <- lm(disease ~ term, data = midas)
res <- runMiDAS(object, experiment = "hla_alleles", inheritance_model = "additive")
kableResults(results = res,
             colnames = c("HLA allele" = "allele"))

}
