% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hlaCallsGranthamDistance}
\alias{hlaCallsGranthamDistance}
\title{Calculate Grantham distance between HLA alleles}
\usage{
hlaCallsGranthamDistance(
  hla_calls,
  genes = c("A", "B", "C"),
  aa_selection = "binding_groove"
)
}
\arguments{
\item{hla_calls}{HLA calls data frame, as returned by
\code{\link{readHlaCalls}} function.}

\item{genes}{Character vector specifying genes for which allelic distance
should be calculated.}

\item{aa_selection}{String specifying variable region in peptide binding
groove which should be considered for Grantham distance calculation. Valid
choices includes: \code{"binding_groove"}, \code{"B_pocket"},
\code{"F_pocket"}. See details for more information.}
}
\value{
Data frame of normalized Grantham distances between pairs of alleles
  for each specified HLA gene. First column (\code{ID}) is the same as in
  \code{hla_calls}, further columns are named as given by \code{genes}.
}
\description{
\code{hlaCallsGranthamDistance} calculate Grantham distance between two HLA
alleles of a given, using original formula by
\href{http://www.sciencemag.org/content/185/4154/862.long}{Grantham R. 1974.}.
}
\details{
Grantham distance is calculated only for class I HLA alleles. First
exons forming the variable region in the peptide binding groove are selected.
Here we provide option to choose either  \code{"binding_groove"} - exon 2 and
3 (positions 1-182 in IMGT/HLA alignments, however here we take 2-182 as many
1st positions are missing), \code{"B_pocket"} -  residues 7, 9, 24, 25, 34,
45, 63, 66, 67, 70, 99 and \code{"F_pocket"} - residues 77, 80, 81, 84, 95,
116, 123, 143, 146, 147. Then all the alleles containing gaps, stop codons or
indels are discarded. Finally distance is calculated for each pair.

See \href{https://europepmc.org/article/med/28650991}{Robinson J. 2017.} for
more details on the choice of exons 2 and 3.
}
\examples{
hlaCallsGranthamDistance(MiDAS_tut_HLA, genes = "A")

}
