% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkKirGenesFormat}
\alias{checkKirGenesFormat}
\title{Check KIR genes format}
\usage{
checkKirGenesFormat(genes)
}
\arguments{
\item{genes}{Character vector with KIR gene names.}
}
\value{
Logical vector specifying if \code{genes} elements follow KIR genes
  naming conventions.
}
\description{
\code{checkKirGenesFormat} test if the input character follows KIR gene names
naming conventions.
}
\details{
KIR genes: "KIR3DL3", "KIR2DS2", "KIR2DL2", "KIR2DL3", "KIR2DP1", "KIR2DL1",
"KIR3DP1", "KIR2DL1", "KIR3DP1", "KIR2DL4", "KIR3DL1", "KIR3DS1", "KIR2DL5",
"KIR2DS3", "KIR2DS5", "KIR2DS4", "KIR2DS1", "KIR3DL2".
}
\examples{
checkKirGenesFormat(c("KIR3DL3", "KIR2DS2", "KIR2DL2"))

}
