% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform}
\alias{transform}
\title{Data Transformations for phyloseq Objects}
\usage{
transform(
  x,
  transform = "identity",
  target = "OTU",
  shift = 0,
  scale = 1,
  log10 = TRUE,
  reference = 1,
  ...
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{transform}{Transformation to apply. The options include:
'compositional' (ie relative abundance), 'Z', 'log10', 'log10p',
'hellinger', 'identity', 'clr', 'alr', or any method from the
vegan::decostand function.}

\item{target}{Apply the transform for 'sample' or 'OTU'.
Does not affect the log transform.}

\item{shift}{A constant indicating how much to shift the baseline
abundance (in transform='shift')}

\item{scale}{Scaling constant for the abundance values when
transform = "scale".}

\item{log10}{Used only for Z transformation. Apply log10 before Z.}

\item{reference}{Reference feature for the alr transformation.}

\item{...}{arguments to be passed}
}
\value{
Transformed \code{\link{phyloseq}} object
}
\description{
Standard transforms for \code{\link{phyloseq-class}}.
}
\details{
In transformation typ, the 'compositional' abundances are returned
as relative abundances in [0, 1] (convert to percentages by multiplying
with a factor of 100). The Hellinger transform is square root of the
relative abundance but instead given at the scale [0,1]. The log10p
transformation refers to log10(1 + x). The log10 transformation is applied
as log10(1 + x) if the data contains zeroes. CLR transform applies
a pseudocount of min(relative abundance)/2 to exact zero relative
abundance entries in OTU table before taking logs.
}
\examples{

data(dietswap)
x <- dietswap

# No transformation
xt <- transform(x, 'identity')

# OTU relative abundances
# xt <- transform(x, 'compositional')

# Z-transform for OTUs
# xt <- transform(x, 'Z', 'OTU')

# Z-transform for samples
# xt <- transform(x, 'Z', 'sample')

# Log10 transform (log10(1+x) if the data contains zeroes)
# xt <- transform(x, 'log10')

# Log10p transform (log10(1+x) always)
# xt <- transform(x, 'log10p')

# CLR transform
# Note that small pseudocount is added if data contains zeroes
xt <- microbiome::transform(x, 'clr')

# ALR transform
# The pseudocount must be specified explicitly
# The reference feature is 1 by default
xt <- microbiome::transform(x, 'alr', shift=1, reference=1)

# Shift the baseline
# xt <- transform(x, 'shift', shift=1)

# Scale
# xt <- transform(x, 'scale', scale=1)

}
\keyword{utilities}
