% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top.R
\name{top}
\alias{top}
\title{Identify Top Entries}
\usage{
top(
  x,
  field = NULL,
  n = NULL,
  output = "vector",
  round = NULL,
  na.rm = FALSE,
  include.rank = FALSE
)
}
\arguments{
\item{x}{data.frame, matrix, or vector}

\item{field}{Field or column to check for a data.frame or matrix}

\item{n}{Number of top entries to show}

\item{output}{Output format: vector or data.frame}

\item{round}{Optional rounding}

\item{na.rm}{Logical. Remove NA before calculating the statistics.}

\item{include.rank}{Include ranking if the output is data.frame. Logical.}
}
\value{
Vector of top counts, named by the corresponding entries
}
\description{
Identify top entries in a vector or given field in data frame.
}
\examples{
  data(dietswap)
  p <- top(meta(dietswap), "group", 10)
}
\references{
See citation("bibliographica")
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
