% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_phyloseq.R
\name{read_phyloseq}
\alias{read_phyloseq}
\title{Import phyloseq Data}
\usage{
read_phyloseq(
  otu.file = NULL,
  taxonomy.file = NULL,
  metadata.file = NULL,
  type = c("simple", "mothur", "biom"),
  sep = ","
)
}
\arguments{
\item{otu.file}{File containing the OTU table (for mothur this is the file
with the .shared extension)}

\item{taxonomy.file}{(for mothur this is typically the consensus taxonomy
file with the .taxonomy extension)}

\item{metadata.file}{File containing samples x variables metadata.}

\item{type}{Input data type: 'mothur' or 'simple' or 'biom' type.}

\item{sep}{CSV file separator}
}
\value{
\code{\link{phyloseq-class}} object
}
\description{
Read the otu, taxonomy and metadata from various formats.
}
\details{
See help(read_mothur2phyloseq) for details on the Mothur input
format; and help(read_biom2phyloseq) for details on the biom format.
The simple format refers to the set of CSV files.
}
\examples{
#  pseq <- read_phyloseq(otu.file, 
#                     taxonomy.file, 
#                     metadata.file, 
#                     type=c('mothur', 'simple', 'biom'))
}
\author{
Sudarshan A. Shetty \email{sudarshanshetty9@gmail.com}
}
\keyword{utilities}
