% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potential_analysis.R
\name{potential_analysis}
\alias{potential_analysis}
\title{Bootstrapped Potential Analysis}
\usage{
potential_analysis(
  x,
  peak.threshold = 0,
  bw.adjust = 1,
  bs.iter = 100,
  min.density = 1
)
}
\arguments{
\item{x}{Input data vector}

\item{peak.threshold}{Mode detection threshold}

\item{bw.adjust}{Bandwidth adjustment}

\item{bs.iter}{Bootstrap iterations}

\item{min.density}{minimum accepted density for a maximum; as a multiple of
kernel height}
}
\value{
List with following elements:
\itemize{
\item{modes}{Number of modes for the input data vector
(the most frequent number of modes from bootstrap)}
\item{minima}{Average of potential minima across the bootstrap samples
(for the most frequent number of modes)}
\item{maxima}{Average of potential maxima across the bootstrap samples
(for the most frequent number of modes)}
\item{unimodality.support}{Fraction of bootstrap samples exhibiting
unimodality}
\item{bws}{Bandwidths}
}
}
\description{
Analysis of multimodality based on bootstrapped potential
analysis of Livina et al. (2010) as described in Lahti et al. (2014).
}
\examples{

# Example data; see help(peerj32) for details
data(peerj32)

# Log10 abundance of Dialister
x <- abundances(transform(peerj32$phyloseq, "clr"))['Dialister',]

# Bootstrapped potential analysis
# In practice, use more bootstrap iterations
# res <- potential_analysis(x, peak.threshold=0, bw.adjust=1,
#    bs.iter=9, min.density=1)

}
\references{
\itemize{
\item{}{Livina et al. (2010). Potential analysis reveals changing number
of climate states during the last 60 kyr.
\emph{Climate of the Past}, 6, 77-82.}
\item{}{Lahti et al. (2014). Tipping elements of the human intestinal
ecosystem. \emph{Nature Communications} 5:4344.}
}
}
\seealso{
plot_potential
}
