% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tipping.R
\name{plot_tipping}
\alias{plot_tipping}
\title{Variation Line Plot}
\usage{
plot_tipping(
  x,
  taxon,
  tipping.point = NULL,
  lims = NULL,
  shift = 0.001,
  xlim = NULL
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{taxon}{Taxonomic group to visualize.}

\item{tipping.point}{Optional. Indicate critical point for abundance
variations to be highlighted.}

\item{lims}{Optional. Figure X axis limits.}

\item{shift}{Small constant to avoid problems with zeroes in log10}

\item{xlim}{Horizontal axis limits}
}
\value{
\code{\link{ggplot}} object
}
\description{
Plot variation in taxon abundance for many subjects.
}
\details{
Assuming the sample_data(x) has 'subject' field and
some subjects have multiple time points.
}
\examples{
data(atlas1006)
pseq <- subset_samples(atlas1006, DNA_extraction_method == 'r')
pseq <- transform(pseq, 'compositional')
p <- plot_tipping(pseq, 'Dialister', tipping.point=1)
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
