% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_landscape.R
\name{plot_landscape}
\alias{plot_landscape}
\title{Landscape Plot}
\usage{
plot_landscape(
  x,
  method = "PCoA",
  distance = "bray",
  transformation = "identity",
  col = NULL,
  main = NULL,
  x.ticks = 10,
  rounding = 0,
  add.points = TRUE,
  adjust = 1,
  size = 1,
  legend = FALSE,
  shading = TRUE,
  shading.low = "#ebf4f5",
  shading.high = "#e9b7ce",
  point.opacity = 0.75
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object or a data matrix
(samples x features; eg. samples vs. OTUs). If the input x is a 2D matrix
then it is plotted as is.}

\item{method}{Ordination method, see phyloseq::plot_ordination; or "PCA",
or "t-SNE" (from the \pkg{Rtsne} package)}

\item{distance}{Ordination distance, see phyloseq::plot_ordination; for
method = "PCA", only euclidean distance is implemented now.}

\item{transformation}{Transformation applied on the input object x}

\item{col}{Variable name to highlight samples (points) with colors}

\item{main}{title text}

\item{x.ticks}{Number of ticks on the X axis}

\item{rounding}{Rounding for X axis tick values}

\item{add.points}{Plot the data points as well}

\item{adjust}{Kernel width adjustment}

\item{size}{point size}

\item{legend}{plot legend TRUE/FALSE}

\item{shading}{Add shading in the background.}

\item{shading.low}{Color for shading low density regions}

\item{shading.high}{Color for shading high density regions}

\item{point.opacity}{Transparency-level for points}
}
\value{
A \code{\link{ggplot}} plot object.
}
\description{
Wrapper for visualizing sample similarity landscape
ie. sample density in various 2D projections.
}
\details{
For consistent results, set random seet (set.seed) before
function call. Note that the distance and transformation arguments may
have a drastic effect on the outputs.
}
\examples{

data(dietswap)

# PCoA
p <- plot_landscape(transform(dietswap, "compositional"),
   distance = "bray", method = "PCoA")

p <- plot_landscape(dietswap, method = "t-SNE", distance = "bray",
       transformation = "compositional")

# PCA
p <- plot_landscape(dietswap, method = "PCA", transformation = "clr")

}
\keyword{utilities}
