% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_core.R
\name{plot_core}
\alias{plot_core}
\title{Visualize OTU Core}
\usage{
plot_core(
  x,
  prevalences = seq(0.1, 1, 0.1),
  detections = 20,
  plot.type = "lineplot",
  colours = NULL,
  min.prevalence = NULL,
  taxa.order = NULL,
  horizontal = FALSE
)
}
\arguments{
\item{x}{A \code{\link{phyloseq}} object or a core matrix}

\item{prevalences}{a vector of prevalence percentages in [0,1]}

\item{detections}{a vector of intensities around the data range,
or a scalar indicating the number of intervals in the data range.}

\item{plot.type}{Plot type ('lineplot' or 'heatmap')}

\item{colours}{colours for the heatmap}

\item{min.prevalence}{If minimum prevalence is set, then filter out those
rows (taxa) and columns (detections) that never exceed this
prevalence. This helps to zoom in on the actual core region
of the heatmap. Only affects the plot.type='heatmap'.}

\item{taxa.order}{Ordering of the taxa: a vector of names.}

\item{horizontal}{Logical. Horizontal figure.}
}
\value{
A list with three elements: the ggplot object and the data.
The data has a different form for the lineplot and heatmap.
Finally, the applied parameters are returned.
}
\description{
Core visualization (2D).
}
\examples{
data(dietswap)
p <- plot_core(transform(dietswap, "compositional"),
  prevalences=seq(0.1, 1, .1), detections=seq(0.01, 1, length = 10))
}
\references{
A Salonen et al. The adult intestinal core microbiota is determined by 
analysis depth and health status. Clinical Microbiology and Infection 
18(S4):16 20, 2012. 
To cite the microbiome R package, see citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
