% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neatsort.R
\name{neatsort}
\alias{neatsort}
\title{Neatmap Sorting}
\usage{
neatsort(x, target, method = "NMDS", distance = "bray", first = NULL, ...)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object or a matrix}

\item{target}{For \code{\link{phyloseq-class}} input, the target is either
'sites' (samples) or 'species' (features) (taxa/OTUs); for matrices,
the target is 'rows' or 'cols'.}

\item{method}{Ordination method. See \code{\link{ordinate}}
from \pkg{phyloseq} package.
For matrices, only the NMDS method is available.}

\item{distance}{Distance method. See \code{\link{ordinate}}
from \pkg{phyloseq} package.}

\item{first}{Optionally provide the name of the first sample/taxon to
start the ordering (the ordering is cyclic so we can start at any
point). The choice of the first sample may somewhat affect the
overall ordering.}

\item{...}{Arguments to be passed.}
}
\value{
Vector of ordered elements
}
\description{
Sort samples or features based on the neatmap approach.
}
\details{
This function borrows elements from the heatmap implementation in
the \pkg{phyloseq} package. The row/column sorting is there not available
as a separate function at present, however, hindering reuse in other tools.
Implemented in the microbiome package to provide an independent method for
easy sample/taxon reordering for phyloseq objects.
}
\examples{
data(peerj32)
pseq <- peerj32$phyloseq
# For Phyloseq
sort.otu <- neatsort(pseq, target='species')
# For matrix
# sort.rows <- neatsort(abundances(pseq), target='rows')

}
\references{
This function is partially based on code derived from the
\pkg{phyloseq} package. For the original
neatmap approach for heatmap sorting, see (and cite):
Rajaram, S., & Oono, Y. (2010). NeatMap--non-clustering heat map
alternatives in R. BMC Bioinformatics, 11, 45.
}
\keyword{utilities}
