% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_compositional.R
\name{is_compositional}
\alias{is_compositional}
\title{Test Compositionality}
\usage{
is_compositional(x, tolerance = 1e-06)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{tolerance}{Tolerance for detecting compositionality.}
}
\value{
Logical TRUE/FALSE
}
\description{
Test if phyloseq object is compositional.
}
\details{
This function tests that the sum of abundances within each sample
is almost zero, within the tolerance of 1e-6 by default.
}
\examples{
data(dietswap)
a <- is_compositional(dietswap)
b <- is_compositional(transform(dietswap, "identity"))
c <- is_compositional(transform(dietswap, "compositional"))
}
\seealso{
transform
}
\keyword{utilities}
