% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_members.R
\name{core_members}
\alias{core_members}
\alias{prevalent_taxa}
\title{Core Taxa}
\usage{
core_members(x, detection = 1/100, prevalence = 50/100, include.lowest = FALSE)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{detection}{Detection threshold for absence/presence
(strictly greater by default).}

\item{prevalence}{Prevalence threshold (in [0, 1]). The
required prevalence is strictly greater by default. To include the
limit, set include.lowest to TRUE.}

\item{include.lowest}{Include the lower boundary of the detection and
prevalence cutoffs. FALSE by default.}
}
\value{
Vector of core members
}
\description{
Determine members of the core microbiota with given abundance
and prevalences
}
\details{
For phyloseq object, lists taxa that are more prevalent with the
given detection threshold. For matrix, lists columns that satisfy
these criteria.
}
\examples{
data(dietswap)
# Detection threshold 1 (strictly greater by default);
# Note that the data (dietswap) is here in absolute counts
# (and not compositional, relative abundances)
# Prevalence threshold 50 percent (strictly greater by default)
a <- core_members(dietswap, 1, 50/100)
}
\references{
A Salonen et al. The adult intestinal core microbiota is determined by 
analysis depth and health status. Clinical Microbiology and Infection 
18(S4):16 20, 2012. 
To cite the microbiome R package, see citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
