% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_taxa.R
\name{aggregate_taxa}
\alias{aggregate_taxa}
\title{Aggregate Taxa}
\usage{
aggregate_taxa(x, level, verbose = FALSE)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{level}{Summarization level (from \code{rank_names(pseq)})}

\item{verbose}{verbose}
}
\value{
Summarized phyloseq object
}
\description{
Summarize phyloseq data into a higher phylogenetic level.
}
\details{
This provides a convenient way to aggregate phyloseq OTUs
(or other taxa) when the phylogenetic tree is missing. Calculates the
sum of OTU abundances over all OTUs that map to the same higher-level
group. Removes ambiguous levels from the taxonomy table. Returns a
phyloseq object with the summarized abundances.
}
\examples{
data(dietswap)
s <- aggregate_taxa(dietswap, 'Phylum')
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
