% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_functions.R
\name{plotlyHistogram}
\alias{plotlyHistogram}
\title{Function plotting a plotly histogram on the given histvalue}
\usage{
plotlyHistogram(
  histvalue,
  plotTitle,
  xaxisTitle = "",
  yaxisTitle = "",
  pwidth = 200,
  pheight = 200
)
}
\arguments{
\item{histvalue}{the value to plot as a histogram}

\item{plotTitle}{title of the plot}

\item{xaxisTitle}{name of xaxis; default is ""}

\item{yaxisTitle}{name of yaxis; default is ""}

\item{pwidth}{overall plot width; default is 200}

\item{pheight}{overall plot height; default is 200}
}
\value{
plotly plot object
}
\description{
Function plotting a plotly histogram on the given histvalue
}
\examples{
data("mouseData", package = "metagenomeSeq")
plotlyHistogram(histvalue = colSums(MRcounts(mouseData) > 0),
  plotTitle = "Feature distribution",
  xaxisTitle = "features", yaxisTitle = "frequency")

}
