% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggreg_norm_functions.R
\name{normalizeData}
\alias{normalizeData}
\title{Calls appropriate normalization functions depending on input parameter
The two available methods included in the package are based on either 
calculating proportions or by using cumulative sum scaling (CSS), 
Paulson, et al. Nat Meth 2013.}
\usage{
normalizeData(MRobj, norm_method)
}
\arguments{
\item{MRobj}{the MRexperiment}

\item{norm_method}{method to use for normalization; CSS or Proportional}
}
\value{
the normalized MRobj
}
\description{
Calls appropriate normalization functions depending on input parameter
The two available methods included in the package are based on either 
calculating proportions or by using cumulative sum scaling (CSS), 
Paulson, et al. Nat Meth 2013.
}
\examples{
data("mouseData", package = "metagenomeSeq")
normalizeData(mouseData, norm_method = "CSS")

}
