% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_functions.R
\name{makeQCPlot}
\alias{makeQCPlot}
\title{Plots sequencing statistics scatterplot}
\usage{
makeQCPlot(
  MRobj,
  col_by = NULL,
  log = "none",
  filter_feat = 0,
  filter_read = 0,
  allowWebGL = TRUE,
  pwidth = 550,
  pheight = 550
)
}
\arguments{
\item{MRobj}{metagenomeSeq object to be plotted}

\item{col_by}{factor by which to color the points}

\item{log}{character indicating which (if any) axes should be shown as log}

\item{filter_feat}{Numeric Y-coordinate to draw horizontal dashed line to
indicate feature filtering. If 0 (default), no line is drawn.}

\item{filter_read}{Numeric X-coordinate to draw vertical dashed line to
indicate read count filtering. If 0 (default), no line is drawn.}

\item{allowWebGL}{boolean indicating if webGL should be added}

\item{pwidth}{overall plot width; default is 550 (125 are added for legend)}

\item{pheight}{overall plot height; default is 550}
}
\value{
the plotly QC plot
}
\description{
This function makes a scatterplot of read and feature counts
for each sample. It was adjusted based on original work by Mo Huang
}
\examples{
data("mouseData", package = "metagenomeSeq")
makeQCPlot(mouseData)

}
\author{
Janina Reeder
}
