% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{filterByPheno}
\alias{filterByPheno}
\title{Function to filter the MRexperiment by certain phenotype values}
\usage{
filterByPheno(MRobj, rm_phenovalues)
}
\arguments{
\item{MRobj}{the MRexperiment to subset}

\item{rm_phenovalues}{list of named vectors with names corresponding to 
column names in pData and values representing phenotypes within the column}
}
\value{
the filtered MRobj
}
\description{
Function to filter the MRexperiment by certain phenotype values
}
\examples{
data("mouseData", package = "metagenomeSeq")
filterByPheno(MRobj = mouseData, 
  rm_phenovalues = list("diet" = c("BK"),"mouseID" = c("PM1","PM10")))

}
\author{
Janina Reeder
}
