% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inter_functions.R
\name{computeDistMat}
\alias{computeDistMat}
\title{Function to compute the distance matrix using vegdist from the vegan package}
\usage{
computeDistMat(aggdat, dist_method, log = TRUE, nfeatures = nrow(aggmat))
}
\arguments{
\item{aggdat}{aggregated MRExperiment}

\item{dist_method}{distance method from vegan package (See ?vegan::vegdist for details)}

\item{log}{transform count matrix to log2; default is TRUE}

\item{nfeatures}{number of features to use; default is all}
}
\value{
distance as dist
}
\description{
Function to compute the distance matrix using vegdist from the vegan package
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
computeDistMat(aggdat, dist_method = "bray")

}
