% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmSscatter.R
\name{plotmSscatter}
\alias{plotmSscatter}
\title{Plot a scatter and side boxplot of the stability results.}
\usage{
plotmSscatter(results, order = NULL, times, gridLines = FALSE, sideScale = 0.3)
}
\arguments{
\item{results}{input data.frame resulting from \code{\link[=mSpreviz]{mSpreviz()}}.}

\item{order}{NULL object or character: mean or median; if the individuals
should be sorted by any of those statistics of the stability values.}

\item{times}{a vector with the names of each paired time, e.g. "t1_t2".}

\item{gridLines}{logical; FALSE to print a blank background or TRUE to
include a gray grid.}

\item{sideScale}{numeric; scale of the side boxplot.}
}
\value{
A scatter plot and a side boxplot of the stability values in the
form of a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plot a scatter and side boxplot of the stability results.
}
\examples{
data(clr)
times <- pairedTimes(data = clr, sequential = TRUE, common = "_0_")
mS <- iterativeClustering(pairedTimes = times, common = "_")
results <- mSpreviz(results = mS, times = times)
plotmSscatter(results = results, order = "median", times = c("t1_t25", 
                                                         "t25_t26"), 
          gridLines = TRUE, sideScale = 0.2)
}
