% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmSheatmap.R
\name{plotmSheatmap}
\alias{plotmSheatmap}
\title{Plot a heatmap of the stability results.}
\usage{
plotmSheatmap(
  results,
  order = NULL,
  times,
  label = FALSE,
  low = "red2",
  mid = "yellow",
  high = "forestgreen",
  midpoint = 0.5
)
}
\arguments{
\item{results}{input data.frame resulting from \code{\link[=mSpreviz]{mSpreviz()}}.}

\item{order}{NULL object or character: none, mean or median; if the
individuals should be sorted by any of those statistics of the
stability values.}

\item{times}{character; names of the paired times to plot,
i.e. colnames of results.}

\item{label}{logical; TRUE to print the mS score or FALSE to not.}

\item{low}{color for the lowest value.}

\item{mid}{color for the middle value.}

\item{high}{color for the highest values.}

\item{midpoint}{value to situate the middle.}
}
\value{
A heatmap of the stability values in the form of a
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plot a heatmap of the stability results.
}
\examples{
data(clr)
times <- pairedTimes(data = clr, sequential = TRUE, common = "_0_")
mS <- iterativeClustering(pairedTimes = times, common = "_")
results <- mSpreviz(results = mS, times = times)
plotmSheatmap(results = results, order = "mean", times = c("t1_t25", "t25_t26"), 
          label = TRUE)
}
