% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmSdynamics.R
\name{plotmSdynamics}
\alias{plotmSdynamics}
\title{Generate boxplots of the stability dynamics throughout sampling times
by groups.}
\usage{
plotmSdynamics(results, groups, points = TRUE, linetype = 2)
}
\arguments{
\item{results}{input data.frame resulting from \code{\link[=mSpreviz]{mSpreviz()}}.}

\item{groups}{vector with the same length as individuals, i.e. the number
of rows in the \code{\link[=mSpreviz]{mSpreviz()}} output.}

\item{points}{logical; FALSE to only visualize boxplots or TRUE to also add
individual points.}

\item{linetype}{numeric; type of line to connect the median value of
paired times; 0 to avoid the line.}
}
\value{
A plot with as many boxes as paired times by group in the form of a
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generate boxplots of the stability dynamics throughout sampling times
by groups.
}
\examples{
data(clr)
times <- pairedTimes(data = clr, sequential = TRUE, common = "_0_")
mS <- iterativeClustering(pairedTimes = times, common = "_")
results <- mSpreviz(results = mS, times = times)
metadata <- data.frame(Sample = rownames(clr), age = c(rep("youth", 65), 
                       rep("old", 131-65)))
group <- mSmetadataGroups(metadata = metadata, samples = metadata$Sample, 
                          common = "_0_", individuals = results$individual, 
                          variable = "age")
plotmSdynamics(results, groups = group, points = TRUE, linetype = 0)
}
