% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairedTimes.R
\docType{methods}
\name{pairedTimes}
\alias{pairedTimes}
\alias{pairedTimes,matrix-method}
\alias{pairedTimes,matrix,matrix-method}
\alias{pairedTimes,TreeSummarizedExperiment-method}
\alias{pairedTimes,TreeSummarizedExperiment,TreeSummarizedExperiment-method}
\title{Generate one or multiple matrices with paired times.}
\usage{
pairedTimes(data, ...)

\S4method{pairedTimes}{matrix}(data, sequential, common, specifiedTimePoints)

\S4method{pairedTimes}{TreeSummarizedExperiment}(
  data,
  sequential,
  assay,
  alternativeExp,
  ID,
  timePoints,
  specifiedTimePoints
)
}
\arguments{
\item{data}{input object: either a matrix with rownames including ID, common
pattern and sampling time, or a TreeSummarizedExperiment object.}

\item{...}{Additional argument list that might not ever be used.}

\item{sequential}{TRUE if paired times to analyse are sequential and present
the desired alphanumerical order.}

\item{common}{If is.matrix(data), pattern that separates the ID and
the sampling time in rownames.}

\item{specifiedTimePoints}{character vector to specify the selection
of concrete paired times.}

\item{assay}{If class(data) == "TreeSummarizedExperiment",
name of the assay to use.}

\item{alternativeExp}{If class(data) == "TreeSummarizedExperiment",
name of the alternative experiment to use (if applicable).}

\item{ID}{If class(data) == "TreeSummarizedExperiment", one of the
colData(data) colnames should be given as individuals.}

\item{timePoints}{If class(data) == "TreeSummarizedExperiment",
one of the colData(data) colnames should be given as sampling times.}
}
\value{
A list of matrices with the same number of columns as input and
with samples from paired sampling times as rows.
}
\description{
Generate one or multiple matrices with paired times.
}
\examples{
data(clr)
times <- pairedTimes(data = clr, sequential = TRUE, common = "_0_")
times_b <- pairedTimes(data = clr, sequential = FALSE, common = "_0_", 
                       specifiedTimePoints = c("1", "26"))
}
