% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mSmetadataGroups.R
\name{mSmetadataGroups}
\alias{mSmetadataGroups}
\title{Easily extract groups of individuals from sample metadata.}
\usage{
mSmetadataGroups(
  metadata,
  samples,
  individuals,
  variable,
  common,
  ID,
  timePoints
)
}
\arguments{
\item{metadata}{input data.frame with data corresponding to samples. It can
be the \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::colData()}} from the
TreeSummarizedExperiment.}

\item{samples}{vector from metadata corresponding to the samples ID,
if applicable; should be NULL if ID and timePoints are provided
from a TreeSummarizedExperiment, for example.}

\item{individuals}{vector of individuals; first column of the
\code{\link[=mSpreviz]{mSpreviz()}} output.}

\item{variable}{column name with the variable used for grouping individuals.}

\item{common}{pattern that separates the ID and the sampling time in
rownames, if applicable.}

\item{ID}{If applicable, one of the colData() colnames from the
TreeSummarizedExperiment should be given as individuals.}

\item{timePoints}{If applicable, one of the colData() colnames from the
TreeSummarizedExperiment should be given as sampling times.}
}
\value{
A vector with the same length as the number of rows in the
\code{\link[=mSpreviz]{mSpreviz()}} output.
}
\description{
Easily extract groups of individuals from sample metadata.
}
\examples{
data(clr)
times <- pairedTimes(data = clr, sequential = TRUE, common = "_0_")
mS <- iterativeClustering(pairedTimes = times, common = "_")
results <- mSpreviz(results = mS, times = times)
metadata <- data.frame(Sample = rownames(clr), age = c(rep("youth", 65), 
                       rep("old", 131-65)))
group <- mSmetadataGroups(metadata = metadata, samples = metadata$Sample, 
                          common = "_0_", individuals = results$individual, 
                          variable = "age")
}
