% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mSinternalPairedTimes.R
\name{mSinternalPairedTimes}
\alias{mSinternalPairedTimes}
\title{Internal function for \code{\link[=pairedTimes]{pairedTimes()}}.}
\usage{
mSinternalPairedTimes(data, specifiedTimePoints, common = "_")
}
\arguments{
\item{data}{matrix with rownames including ID, common pattern and sampling time.}

\item{specifiedTimePoints}{character vector to specify the selection of
concrete paired times.}

\item{common}{pattern separating the ID and the sampling time in rownames.}
}
\value{
A list of matrices with the same number of columns as input and with
samples from paired sampling times as rows.
}
\description{
Internal function for \code{\link[=pairedTimes]{pairedTimes()}}.
}
\examples{
data(clr)
t1_t2 <- mSinternalPairedTimes(data = clr, 
                               specifiedTimePoints = c("1", "25"), 
                               common = "_0_")
}
