#' Detected ASV from multiple individuals at four different sampling times.
#'
#' A dataset containing the amplicon sequence variants of 131 samples from the 
#' gut microbiota of 43 individuals. The values are transformed from counts by 
#' applying centred log-transformation (CLR).
#'
#' @format A data.frame with 131 rows and 226 variables
#' @references Gloria M. Agudelo-Ochoa, Beatriz E. Valdés-Duque, Nubia A. 
#' Giraldo-Giraldo, Ana M. Jaillier-Ramírez, Adriana Giraldo-Villa, 
#' Irene Acevedo-Castaño, Mónica A. Yepes-Molina, Janeth Barbosa-Barbosa, 
#' Alfonso Benítez-Paéz, Gut microbiota profiles in critically ill patients, 
#' potential biomarkers and risk variables for sepsis, Gut Microbes, Volume 12,
#' Issue 1, January 2020, https://doi.org/10.1080/19490976.2019.1707610
#' @references Pedro Sánchez-Sánchez, Francisco J Santonja, 
#' Alfonso Benítez-Páez, Assessment of human microbiota stability across 
#' longitudinal samples using iteratively growing-partitioned clustering, 
#' Briefings in Bioinformatics, Volume 23, Issue 2, March 2022, bbac055, 
#' https://doi.org/10.1093/bib/bbac055
#' @usage data(clr)
"clr"
