% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/decontam.R
\name{addContaminantQC}
\alias{addContaminantQC}
\alias{addNotContaminantQC}
\alias{isContaminant}
\alias{isContaminant,SummarizedExperiment-method}
\alias{isNotContaminant,SummarizedExperiment-method}
\alias{addContaminantQC,SummarizedExperiment-method}
\alias{addNotContaminantQC,SummarizedExperiment-method}
\title{decontam functions}
\usage{
addContaminantQC(x, name = "isContaminant", ...)

addNotContaminantQC(x, name = "isNotContaminant", ...)

\S4method{isContaminant}{SummarizedExperiment}(
  seqtab,
  assay.type = assay_name,
  assay_name = "counts",
  concentration = NULL,
  control = NULL,
  batch = NULL,
  threshold = 0.1,
  normalize = TRUE,
  detailed = TRUE,
  ...
)

\S4method{isNotContaminant}{SummarizedExperiment}(
  seqtab,
  assay.type = assay_name,
  assay_name = "counts",
  control = NULL,
  threshold = 0.5,
  normalize = TRUE,
  detailed = TRUE,
  ...
)

\S4method{addContaminantQC}{SummarizedExperiment}(x, name = "contaminant", ...)

\S4method{addNotContaminantQC}{SummarizedExperiment}(x, name = "not_contaminant", ...)
}
\arguments{
\item{name}{\code{Character scalar}. A name for the column of the
\code{colData} where results will be stored.
(Default: \code{"contaminant"} or \code{"not_contaminant"})}

\item{...}{\itemize{
\item for \code{isContaminant}/ \code{isNotContaminant}: arguments
passed on to \code{\link[decontam:isContaminant]{decontam:isContaminant}}
or \code{\link[decontam:isNotContaminant]{decontam:isNotContaminant}}
\item for \code{addContaminantQC}/\code{addNotContaminantQC}: arguments
passed on to \code{isContaminant}/ \code{isNotContaminant}
}}

\item{seqtab, x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{concentration}{\code{Character scalar} or \code{NULL}. Defining
a column with numeric values from the \code{colData} to use as
concentration information. (Default: \code{NULL})}

\item{control}{\code{Character scalar} or \code{NULL}. Defining a
column with logical values from the \code{colData} to define control and
non-control samples. (Default: \code{NULL})}

\item{batch}{\code{Character scalar} or \code{NULL}. Defining a
column with values interpretable as a factor from the \code{colData} to use
as batch information. (Default: \code{NULL})}

\item{threshold}{\code{Numeric scalar}.. See
\code{\link[decontam:isContaminant]{decontam:isContaminant}} or
\code{\link[decontam:isNotContaminant]{decontam:isNotContaminant}}}

\item{normalize}{\code{Logical scalar}. See
\code{\link[decontam:isContaminant]{decontam:isContaminant}} or
\code{\link[decontam:isNotContaminant]{decontam:isNotContaminant}}}

\item{detailed}{\code{Logical scalar}. If \code{TRUE}, the return value is a
data.frame containing diagnostic information on the contaminant decision.
If FALSE, the return value is a logical vector containing the binary
contaminant classifications. (Default: \code{TRUE})}
}
\value{
for \code{isContaminant}/ \code{isNotContaminant} a \code{DataFrame}
or for \code{addContaminantQC}/\code{addNotContaminantQC} a modified object
of \code{class(x)}
}
\description{
The \code{decontam} functions \code{isContaminant} and
\code{isNotContaminant} are made available for
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
objects.
}
\examples{
data(esophagus)
# setup of some mock data just for example
colData(esophagus)$concentration <- c(1, 2, 3)
colData(esophagus)$control <- c(FALSE, FALSE, TRUE)

isContaminant(
    esophagus,
    method = "frequency",
    concentration = "concentration"
    )
esophagus <- addContaminantQC(
    esophagus,
    method = "frequency",
    concentration = "concentration"
    )
rowData(esophagus)

isNotContaminant(esophagus, control = "control")
esophagus <- addNotContaminantQC(esophagus, control = "control")
rowData(esophagus)

}
\seealso{
\code{\link[decontam:isContaminant]{decontam:isContaminant}},
\code{\link[decontam:isNotContaminant]{decontam:isNotContaminant}}
}
