% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/taxonomy.R
\name{getHierarchyTree}
\alias{getHierarchyTree}
\alias{addHierarchyTree}
\alias{hierarchy-tree}
\alias{getHierarchyTree,SummarizedExperiment-method}
\alias{addHierarchyTree,SummarizedExperiment-method}
\title{Calculate hierarchy tree}
\usage{
getHierarchyTree(x, ...)

addHierarchyTree(x, ...)

\S4method{getHierarchyTree}{SummarizedExperiment}(x, ...)

\S4method{addHierarchyTree}{SummarizedExperiment}(x, ...)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{optional arguments not used currently.}
}
\value{
\itemize{
\item \code{addHierarchyTree}: a \code{TreeSummarizedExperiment} whose
\code{phylo} tree represents the hierarchy among available taxonomy
information.
\item \code{getHierarchyTree}: a \code{phylo} tree representing the
hierarchy among available taxonomy information.
}
}
\description{
These functions generate a hierarchy tree using taxonomic information from a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{SummarizedExperiment}}
object and add this hierarchy tree into the \code{rowTree}.
}
\details{
\code{addHierarchyTree} calculates a hierarchy tree from the available
taxonomic information and add it to \code{rowTree}.

\code{getHierarchyTree} generates a hierarchy tree from the available
taxonomic information. Internally it uses
\code{\link[TreeSummarizedExperiment:toTree]{toTree}} and
\code{\link[TreeSummarizedExperiment:resolveLoop]{resolveLoop}} to sanitize
data if needed.

Please note that a hierarchy tree is not an actual phylogenetic tree.
A phylogenetic tree represents evolutionary relationships among features.
On the other hand, a hierarchy tree organizes species into a hierarchical
structure based on their taxonomic ranks.
}
\examples{
# Generate a tree based on taxonomic rank hierarchy (a hierarchy tree).
data(GlobalPatterns)
tse <- GlobalPatterns
getHierarchyTree(tse)

# Add a hierarchy tree to a TreeSummarizedExperiment.
# Please note that any tree already stored in rowTree() will be overwritten.
tse <- addHierarchyTree(tse)
tse
}
