% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getPrevalence.R
\name{getPrevalence}
\alias{getPrevalence}
\alias{getPrevalent}
\alias{getRare}
\alias{subsetByPrevalent}
\alias{subsetByRare}
\alias{getPrevalentAbundance}
\alias{addPrevalentAbundance}
\alias{addPrevalence}
\alias{addPrevalence,SummarizedExperiment-method}
\alias{getPrevalence,ANY-method}
\alias{getPrevalence,SummarizedExperiment-method}
\alias{getPrevalent,ANY-method}
\alias{getPrevalent,SummarizedExperiment-method}
\alias{getRare,ANY-method}
\alias{getRare,SummarizedExperiment-method}
\alias{subsetByPrevalent,SummarizedExperiment-method}
\alias{subsetByPrevalent,TreeSummarizedExperiment-method}
\alias{subsetByRare,SummarizedExperiment-method}
\alias{subsetByRare,TreeSummarizedExperiment-method}
\alias{addPrevalentAbundance,SummarizedExperiment-method}
\alias{getPrevalentAbundance,ANY-method}
\alias{getPrevalentAbundance,SummarizedExperiment-method}
\title{Calculation prevalence information for features across samples}
\usage{
getPrevalence(x, ...)

getPrevalent(x, ...)

getRare(x, ...)

subsetByPrevalent(x, ...)

subsetByRare(x, ...)

getPrevalentAbundance(
  x,
  assay.type = assay_name,
  assay_name = "relabundance",
  ...
)

addPrevalentAbundance(x, ...)

addPrevalence(x, ...)

\S4method{addPrevalence}{SummarizedExperiment}(x, name = "prevalence", ...)

\S4method{getPrevalence}{ANY}(
  x,
  detection = 0,
  include.lowest = include_lowest,
  include_lowest = FALSE,
  sort = FALSE,
  na.rm = TRUE,
  ...
)

\S4method{getPrevalence}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  rank = NULL,
  ...
)

\S4method{getPrevalent}{ANY}(
  x,
  prevalence = 50/100,
  include.lowest = include_lowest,
  include_lowest = FALSE,
  ...
)

\S4method{getPrevalent}{SummarizedExperiment}(
  x,
  rank = NULL,
  prevalence = 50/100,
  include.lowest = include_lowest,
  include_lowest = FALSE,
  ...
)

\S4method{getRare}{ANY}(
  x,
  prevalence = 50/100,
  include.lowest = include_lowest,
  include_lowest = FALSE,
  ...
)

\S4method{getRare}{SummarizedExperiment}(
  x,
  rank = NULL,
  prevalence = 50/100,
  include.lowest = include_lowest,
  include_lowest = FALSE,
  ...
)

\S4method{subsetByPrevalent}{SummarizedExperiment}(x, rank = NULL, ...)

\S4method{subsetByPrevalent}{TreeSummarizedExperiment}(x, update.tree = TRUE, ...)

\S4method{subsetByRare}{SummarizedExperiment}(x, rank = NULL, ...)

\S4method{subsetByRare}{TreeSummarizedExperiment}(x, update.tree = TRUE, ...)

\S4method{addPrevalentAbundance}{SummarizedExperiment}(x, name = "prevalent_abundance", ...)

\S4method{getPrevalentAbundance}{ANY}(
  x,
  assay.type = assay_name,
  assay_name = "relabundance",
  ...
)

\S4method{getPrevalentAbundance}{SummarizedExperiment}(x, assay.type = assay_name, assay_name = "counts", ...)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{additional arguments
\itemize{
\item If \code{!is.null(rank)} arguments are passed on to
\code{\link[=agglomerate-methods]{agglomerateByRank}}. See
\code{\link[=agglomerate-methods]{?agglomerateByRank}} for more details.

\item for \code{getPrevalent}, \code{getRare}, \code{subsetByPrevalent}
and \code{subsetByRare} additional parameters passed to
\code{getPrevalence}

\item for \code{getPrevalentAbundance} additional parameters passed to
\code{getPrevalent}
}}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{name}{\code{Character scalar}. Specifies name of column in
\code{rowData} where the results will be stored.
(Default: \code{"prevalence"})}

\item{detection}{\code{Numeric scalar}. Detection threshold for
absence/presence. If \code{as_relative = FALSE},
it sets the counts threshold for a taxon to be considered present.
If \code{as_relative = TRUE}, it sets the relative abundance threshold
for a taxon to be considered present. (Default: \code{0})}

\item{include.lowest}{\code{Logical scalar}. Should the lower boundary of the
detection and prevalence cutoffs be included? (Default: \code{FALSE})}

\item{include_lowest}{Deprecated. Use \code{include.lowest} instead.}

\item{sort}{\code{Logical scalar}. Should the result be sorted by prevalence?
(Default: \code{FALSE})}

\item{na.rm}{\code{Logical scalar}. Should NA values be omitted?
(Default: \code{TRUE})}

\item{rank}{\code{Character scalar}. Defines a taxonomic rank. Must be a
value of \code{taxonomyRanks()} function.}

\item{prevalence}{Prevalence threshold (in 0 to 1). The
required prevalence is strictly greater by default. To include the
limit, set \code{include.lowest} to \code{TRUE}.}

\item{update.tree}{\code{Logical scalar}. Should
\code{rowTree()} also be agglomerated? (Default: \code{TRUE})}
}
\value{
\code{subsetPrevalent} and \code{subsetRareFeatures} return subset of
\code{x}.

All other functions return a named vectors:
\itemize{
\item \code{getPrevalence} returns a \code{numeric} vector with the
names being set to either the row names of \code{x} or the names after
agglomeration. \code{addPrevalence} adds these results to
\code{rowData(x)}.

\item \code{getPrevalentAbundance} returns a \code{numeric} vector with
the names corresponding to the column name of \code{x} and include the
joint abundance of prevalent taxa.

\item \code{getPrevalent} and \code{getRare} return a
\code{character} vector with only the names exceeding the threshold set
by \code{prevalence}, if the \code{rownames} of \code{x} is set.
Otherwise an \code{integer} vector is returned matching the rows in
\code{x}.
}
}
\description{
These functions calculate the population prevalence for taxonomic ranks in a
\code{\link[SummarizedExperiment]{SummarizedExperiment}} object.
}
\details{
\code{getPrevalence} calculates the frequency of samples that exceed
the detection threshold. For \code{SummarizedExperiment} objects, the
prevalence is calculated for the selected taxonomic rank, otherwise for the
rows. The absolute population prevalence can be obtained by multiplying the
prevalence by the number of samples (\code{ncol(x)}).

The core abundance index from \code{getPrevalentAbundance} gives the relative
proportion of the core species (in between 0 and 1). The core taxa are
defined as those that exceed the given population prevalence threshold at the
given detection level as set for \code{getPrevalent}.

\code{subsetPrevalent} and \code{subsetRareFeatures} return a subset of
\code{x}.
The subset includes the most prevalent or rare taxa that are calculated with
\code{getPrevalent} or \code{getRare} respectively.

\code{getPrevalent} returns taxa that are more prevalent with the
given detection threshold for the selected taxonomic rank.

\code{getRare} returns complement of \code{getPrevalent}.
}
\examples{
data(GlobalPatterns)
tse <- GlobalPatterns
# Get prevalence estimates for individual ASV/OTU
prevalence.frequency <- getPrevalence(tse,
                                      detection = 0,
                                      sort = TRUE)
head(prevalence.frequency)

# Get prevalence estimates for phyla
# - the getPrevalence function itself always returns population frequencies
prevalence.frequency <- getPrevalence(tse,
                                      rank = "Phylum",
                                      detection = 0,
                                      sort = TRUE)
head(prevalence.frequency)

# - to obtain population counts, multiply frequencies with the sample size,
# which answers the question "In how many samples is this phylum detectable"
prevalence.count <- prevalence.frequency * ncol(tse)
head(prevalence.count)

# Detection threshold 1 (strictly greater by default);
# Note that the data (GlobalPatterns) is here in absolute counts
# (and not compositional, relative abundances)
# Prevalence threshold 50 percent (strictly greater by default)
prevalent <- getPrevalent(
    tse,
    rank = "Phylum",
    detection = 10,
    prevalence = 50/100)
head(prevalent)

# Add relative aundance data
tse <- transformAssay(tse, assay.type = "counts", method = "relabundance")

# Gets a subset of object that includes prevalent taxa
altExp(tse, "prevalent") <- subsetByPrevalent(tse,
                                             rank = "Family",
                                             assay.type = "relabundance",
                                             detection = 0.001,
                                             prevalence = 0.55)
altExp(tse, "prevalent")

# getRare returns the inverse
rare <- getRare(tse,
    rank = "Phylum",
    assay.type = "relabundance",
    detection = 1/100,
    prevalence = 50/100)
head(rare)

# Gets a subset of object that includes rare taxa
altExp(tse, "rare") <- subsetByRare(
    tse,
    rank = "Class",
    assay.type = "relabundance",
    detection = 0.001,
    prevalence = 0.001)
altExp(tse, "rare")

# Names of both experiments, prevalent and rare, can be found from slot
# altExpNames
tse

data(esophagus)
getPrevalentAbundance(esophagus, assay.type = "counts")

}
\references{
A Salonen et al. The adult intestinal core microbiota is determined by
analysis depth and health status. Clinical Microbiology and Infection
18(S4):16 20, 2012.
To cite the R package, see citation('mia')
}
\seealso{
\code{\link[=agglomerate-methods]{agglomerateByRank}},
\code{\link[=getTop]{getTop}}
}
